/*
 * Decompiled with CFR 0.152.
 */
package sufftracker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sufftracker.DataHolder;

public class SettingsHolder {
    private static SettingsHolder instance;
    private HashMap<String, String> data;
    private File saveFile = new File("suff.ini");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettingsHolder() {
        if (this.saveFile.exists()) {
            FileInputStream fileInput = null;
            ObjectInputStream input = null;
            try {
                fileInput = new FileInputStream(this.saveFile);
                input = new ObjectInputStream(fileInput);
                this.data = (HashMap)input.readObject();
            }
            catch (IOException | ClassNotFoundException ex) {
                System.out.println("Fehler beim Einlesen der ini-Datei");
            }
            finally {
                try {
                    fileInput.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SettingsHolder.class.getName()).log(Level.SEVERE, null, ex);
                }
                try {
                    input.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SettingsHolder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        } else {
            this.data = new HashMap();
        }
    }

    public void ereaseSession() {
        this.save();
        this.saveFile.renameTo(new File("suff_old_" + this.getString("session") + "_" + System.currentTimeMillis() + ".ini"));
    }

    public void put(String key, Object value) {
        this.data.put(key, value.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            if (this.saveFile.exists()) {
                this.saveFile.delete();
            }
            this.saveFile.createNewFile();
        }
        catch (IOException ex) {
            Logger.getLogger(DataHolder.class.getName()).log(Level.SEVERE, null, ex);
        }
        FileOutputStream fileOutput = null;
        ObjectOutputStream output = null;
        try {
            fileOutput = new FileOutputStream(this.saveFile);
            output = new ObjectOutputStream(fileOutput);
            output.writeObject(this.data);
        }
        catch (IOException ex) {
            System.out.println("Fehler beim Speichern der ini-Datei");
        }
        finally {
            try {
                fileOutput.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SettingsHolder.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                output.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SettingsHolder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static SettingsHolder instance() {
        if (instance == null) {
            instance = new SettingsHolder();
        }
        return instance;
    }

    public Integer getInt(String key, Integer def) {
        Integer val = this.getInt(key);
        if (val != null) {
            return val;
        }
        return def;
    }

    public Integer getInt(String key) {
        try {
            return Integer.valueOf(this.data.get(key));
        }
        catch (NullPointerException | NumberFormatException ex) {
            return null;
        }
    }

    public String getString(String key, String def) {
        String val = this.getString(key);
        if (val != null) {
            return val;
        }
        return def;
    }

    public String getString(String key) {
        try {
            return this.data.get(key);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }
}

